<?php

// Configuración de la conexión a la base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'root'); // Reemplaza con tu usuario de MySQL
define('DB_PASS', ''); // Reemplaza con tu contraseña de MySQL
define('DB_NAME', 'facturacion_mvc');
define('DB_CHARSET', 'utf8');

class Database {
    private static $instance = null;
    private $pdo;

    private function __construct() {
        try {
            $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            // En un entorno de producción, no muestres detalles del error.
            // Loguea el error y muestra un mensaje genérico.
            die('Error de conexión a la base de datos: ' . $e->getMessage());
        }
    }

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->pdo;
    }
}
?>
