<?php
// BaseController.php

class BaseController {
    /**
     * Carga una vista.
     *
     * @param string $view El nombre de la vista a cargar (sin la extensión .php).
     * @param array $data Los datos a pasar a la vista.
     */
    protected function view($view, $data = []) {
        extract($data);

        $viewPath = "../views/{$view}.php";

        if (file_exists($viewPath)) {
            // Caso especial para la vista de recibo, que no usa el layout principal.
            if ($view === 'ventas/recibo') {
                require_once $viewPath;
            } else {
                ob_start();
                require_once $viewPath;
                $content = ob_get_clean();
                // La vista normal se carga dentro del layout
                require_once '../views/layout/layout.php';
            }
        } else {
            die("Error: La vista '{$view}' no fue encontrada.");
        }
    }
}
