<?php
// controllers/ClienteController.php

require_once 'BaseController.php';

class ClienteController extends BaseController {
    private $clienteModel;

    public function __construct() {
        $this->clienteModel = new Cliente();
    }

    // Listar todos los clientes
    public function index() {
        $searchTerm = isset($_GET['search']) ? $_GET['search'] : null;
        $clientes = $this->clienteModel->getAll($searchTerm);
        $this->view('clientes/index', [
            'clientes' => $clientes, 
            'title' => 'Gestión de Clientes',
            'searchTerm' => $searchTerm
        ]);
    }

    // Mostrar formulario para crear un nuevo cliente
    public function create() {
        $this->view('clientes/create', ['title' => 'Nuevo Cliente']);
    }

    // Guardar un nuevo cliente en la BD
    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $data = [
                'cedula_ruc' => $_POST['cedula_ruc'],
                'nombre' => $_POST['nombre'],
                'direccion' => $_POST['direccion'],
                'telefono' => $_POST['telefono'],
                'email' => $_POST['email']
            ];
            if ($this->clienteModel->create($data)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=cliente&action=index');
                exit;
            } else {
                die('Error al crear el cliente. ¿La cédula/RUC ya existe?');
            }
        }
    }

    // Mostrar formulario para editar un cliente
    public function edit() {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $cliente = $this->clienteModel->getById($id);
            if ($cliente) {
                $this->view('clientes/edit', ['cliente' => $cliente, 'title' => 'Editar Cliente']);
            } else {
                die('Cliente no encontrado.');
            }
        }
    }

    // Actualizar un cliente en la BD
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id'])) {
            $id = $_POST['id'];
            $data = [
                'cedula_ruc' => $_POST['cedula_ruc'],
                'nombre' => $_POST['nombre'],
                'direccion' => $_POST['direccion'],
                'telefono' => $_POST['telefono'],
                'email' => $_POST['email']
            ];
            if ($this->clienteModel->update($id, $data)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=cliente&action=index');
                exit;
            } else {
                die('Error al actualizar el cliente. ¿La cédula/RUC ya existe?');
            }
        }
    }

    // Eliminar un cliente
    public function delete() {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            if ($this->clienteModel->delete($id)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=cliente&action=index');
                exit;
            } else {
                die('Error al eliminar el cliente.');
            }
        }
    }
}
