<?php
// models/Cliente.php

class Cliente {
    private $db;
    private $pdo;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->pdo = $this->db->getConnection();
    }

    public function getAll($searchTerm = null) {
        $sql = "SELECT * FROM clientes";
        if ($searchTerm) {
            $sql .= " WHERE cedula_ruc LIKE :searchTerm OR nombre LIKE :searchTerm";
        }
        $sql .= " ORDER BY id DESC";
        
        $stmt = $this->pdo->prepare($sql);

        if ($searchTerm) {
            $term = '%' . $searchTerm . '%';
            $stmt->bindParam(':searchTerm', $term);
        }

        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM clientes WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare(
            "INSERT INTO clientes (cedula_ruc, nombre, direccion, telefono, email) VALUES (:cedula_ruc, :nombre, :direccion, :telefono, :email)"
        );
        $stmt->bindParam(':cedula_ruc', $data['cedula_ruc']);
        $stmt->bindParam(':nombre', $data['nombre']);
        $stmt->bindParam(':direccion', $data['direccion']);
        $stmt->bindParam(':telefono', $data['telefono']);
        $stmt->bindParam(':email', $data['email']);
        return $stmt->execute();
    }

    public function update($id, $data) {
        $stmt = $this->pdo->prepare(
            "UPDATE clientes SET cedula_ruc = :cedula_ruc, nombre = :nombre, direccion = :direccion, telefono = :telefono, email = :email WHERE id = :id"
        );
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':cedula_ruc', $data['cedula_ruc']);
        $stmt->bindParam(':nombre', $data['nombre']);
        $stmt->bindParam(':direccion', $data['direccion']);
        $stmt->bindParam(':telefono', $data['telefono']);
        $stmt->bindParam(':email', $data['email']);
        return $stmt->execute();
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM clientes WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        return $stmt->execute();
    }
}
