<?php
// models/Producto.php

class Producto {
    private $db;
    private $pdo;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->pdo = $this->db->getConnection();
    }

    public function getAll() {
        $stmt = $this->pdo->prepare("SELECT * FROM productos ORDER BY id DESC");
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM productos WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare(
            "INSERT INTO productos (codigo, nombre, descripcion, precio_venta, precio_compra, stock) VALUES (:codigo, :nombre, :descripcion, :precio_venta, :precio_compra, :stock)"
        );
        $stmt->bindParam(':codigo', $data['codigo']);
        $stmt->bindParam(':nombre', $data['nombre']);
        $stmt->bindParam(':descripcion', $data['descripcion']);
        $stmt->bindParam(':precio_venta', $data['precio_venta']);
        $stmt->bindParam(':precio_compra', $data['precio_compra']);
        $stmt->bindParam(':stock', $data['stock'], PDO::PARAM_STR); // Puede ser decimal
        return $stmt->execute();
    }

    public function update($id, $data) {
        $stmt = $this->pdo->prepare(
            "UPDATE productos SET codigo = :codigo, nombre = :nombre, descripcion = :descripcion, precio_venta = :precio_venta, precio_compra = :precio_compra, stock = :stock WHERE id = :id"
        );
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':codigo', $data['codigo']);
        $stmt->bindParam(':nombre', $data['nombre']);
        $stmt->bindParam(':descripcion', $data['descripcion']);
        $stmt->bindParam(':precio_venta', $data['precio_venta']);
        $stmt->bindParam(':precio_compra', $data['precio_compra']);
        $stmt->bindParam(':stock', $data['stock'], PDO::PARAM_STR); // Puede ser decimal
        return $stmt->execute();
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM productos WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        return $stmt->execute();
    }
}
