<div class="card">
    <div class="card-header">
        <h2>Reporte de Ventas</h2>
    </div>
    <div class="card-body">
        <!-- Formulario de filtro por fecha -->
        <form action="index.php?controller=reporte&action=ventas" method="POST" class="mb-4">
            <div class="row align-items-end">
                <div class="col-md-4">
                    <label for="fecha_inicio" class="form-label">Fecha Inicio:</label>
                    <input type="date" id="fecha_inicio" name="fecha_inicio" class="form-control" value="<?php echo htmlspecialchars($fecha_inicio); ?>">
                </div>
                <div class="col-md-4">
                    <label for="fecha_fin" class="form-label">Fecha Fin:</label>
                    <input type="date" id="fecha_fin" name="fecha_fin" class="form-control" value="<?php echo htmlspecialchars($fecha_fin); ?>">
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i> Filtrar
                    </button>
                </div>
            </div>
        </form>

        <!-- Tabla de resultados -->
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID Venta</th>
                        <th>Fecha y Hora</th>
                        <th>Cliente</th>
                        <th>Total</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $totalGeneral = 0;
                    foreach ($ventas as $venta): 
                        $totalGeneral += $venta['total'];
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($venta['id']); ?></td>
                        <td><?php echo htmlspecialchars(date("d/m/Y H:i", strtotime($venta['fecha_venta']))); ?></td>
                        <td><?php echo htmlspecialchars($venta['cliente_nombre']); ?></td>
                        <td>$<?php echo htmlspecialchars(number_format($venta['total'], 2)); ?></td>
                        <td>
                            <a href="index.php?controller=venta&action=recibo&id=<?php echo $venta['id']; ?>" class="btn btn-info btn-sm" target="_blank">
                                <i class="bi bi-printer-fill"></i> Ver Recibo
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($ventas)): ?>
                        <tr>
                            <td colspan="5" class="text-center">No se encontraron ventas en el rango de fechas seleccionado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot class="table-group-divider">
                    <tr>
                        <td colspan="3" class="text-end"><strong>Total del Periodo:</strong></td>
                        <td colspan="2"><strong>$<?php echo number_format($totalGeneral, 2); ?></strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
