<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $title; ?></title>
    <style>
        /* Estilos optimizados para impresora térmica de 58mm */
        body {
            font-family: 'Courier New', Courier, monospace;
            font-size: 10px; /* Tamaño de fuente pequeño */
            color: #000;
            width: 56mm; /* Ancho aproximado del papel, dejando un pequeño margen */
            margin: 1mm;
            padding: 0;
        }
        .container {
            width: 100%;
            padding: 5px;
        }
        h1, h2, h3, p {
            margin: 0;
            padding: 2px 0;
            text-align: center;
        }
        hr {
            border: none;
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
        }
        th, td {
            padding: 2px 0;
        }
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }

        .item-row td:nth-child(1) { width: 50%; } /* Nombre producto */
        .item-row td:nth-child(2) { width: 15%; } /* Cantidad */
        .item-row td:nth-child(3) { width: 35%; } /* Subtotal */

        .total-row td {
            font-weight: bold;
            font-size: 11px;
        }

        .footer {
            margin-top: 10px;
            text-align: center;
            font-size: 9px;
        }

        #print-button {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            font-size: 14px;
            cursor: pointer;
            margin-top: 20px;
        }

        @media print {
            body { margin: 0; }
            #print-button { display: none; }
        }
    </style>
</head>
<body>
    <div class="container">
        <h3>Mi Negocio S.A.</h3>
        <p>Dirección del Negocio, Ciudad</p>
        <p>Tel: 123-456-7890</p>
        <hr>
        <p><strong>NOTA DE VENTA #<?php echo htmlspecialchars($venta['id']); ?></strong></p>
        <p>Fecha: <?php echo date("d/m/Y H:i", strtotime($venta['fecha_venta'])); ?></p>
        <hr>
        <p class="text-left"><strong>Cliente:</strong> <?php echo htmlspecialchars($venta['cliente_nombre']); ?></p>
        <hr>
        
        <table>
            <thead>
                <tr>
                    <th class="text-left">Producto</th>
                    <th class="text-center">Cant.</th>
                    <th class="text-right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($detalles as $detalle): ?>
                <tr class="item-row">
                    <td class="text-left"><?php echo htmlspecialchars($detalle['producto_nombre']); ?></td>
                    <td class="text-center"><?php echo htmlspecialchars($detalle['cantidad']); ?></td>
                    <td class="text-right">$<?php echo number_format($detalle['cantidad'] * $detalle['precio_unitario'], 2); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <hr>
        
        <table>
            <tbody>
                <tr class="total-row">
                    <td class="text-left">TOTAL:</td>
                    <td class="text-right">$<?php echo number_format($venta['total'], 2); ?></td>
                </tr>
            </tbody>
        </table>
        
        <hr>

        <div class="footer">
            <p>¡Gracias por su compra!</p>
        </div>
    </div>

    <button id="print-button" onclick="window.print();">Imprimir Recibo</button>

</body>
</html>
