-- Base de datos para el sistema de facturación

CREATE DATABASE IF NOT EXISTS facturacion_mvc;
USE facturacion_mvc;

-- Tabla de Clientes
CREATE TABLE IF NOT EXISTS clientes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    cedula_ruc VARCHAR(20) UNIQUE,
    nombre VARCHAR(255) NOT NULL,
    direccion TEXT,
    telefono VARCHAR(20),
    email VARCHAR(100),
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabla de Productos
CREATE TABLE IF NOT EXISTS productos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    codigo VARCHAR(50) UNIQUE,
    nombre VARCHAR(255) NOT NULL,
    descripcion TEXT,
    precio_venta DECIMAL(10, 2) NOT NULL,
    precio_compra DECIMAL(10, 2) NOT NULL DEFAULT 0.00,
    stock DECIMAL(10, 2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabla de Ventas
CREATE TABLE IF NOT EXISTS ventas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_cliente INT NOT NULL,
    total DECIMAL(10, 2) NOT NULL,
    fecha_venta TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (id_cliente) REFERENCES clientes(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabla de Detalle de Ventas
CREATE TABLE IF NOT EXISTS detalle_ventas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_venta INT NOT NULL,
    id_producto INT NOT NULL,
    cantidad DECIMAL(10, 2) NOT NULL,
    precio_unitario DECIMAL(10, 2) NOT NULL,
    FOREIGN KEY (id_venta) REFERENCES ventas(id) ON DELETE CASCADE,
    FOREIGN KEY (id_producto) REFERENCES productos(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insertar algunos datos de ejemplo (opcional)
INSERT INTO clientes (cedula_ruc, nombre, direccion, telefono, email) VALUES
('1712345678', 'Juan Perez', 'Calle Falsa 123', '555-1234', 'juan.perez@example.com'),
('0987654321', 'Ana Gomez', 'Avenida Siempreviva 742', '555-5678', 'ana.gomez@example.com');

INSERT INTO productos (codigo, nombre, descripcion, precio_venta, precio_compra, stock) VALUES
('P001', 'Teclado USB', 'Teclado estándar USB para PC', 15.50, 10.00, 100.00),
('P002', 'Mouse Óptico', 'Mouse óptico con 3 botones', 10.00, 7.50, 150.00),
('P003', 'Monitor LED 24"', 'Monitor LED de 24 pulgadas Full HD', 150.00, 120.00, 50.00);
