<?php
// controllers/ProductoController.php

require_once 'BaseController.php';

class ProductoController extends BaseController {
    private $productoModel;

    public function __construct() {
        $this->productoModel = new Producto();
    }

    // Listar todos los productos
    public function index() {
        $productos = $this->productoModel->getAll();
        $this->view('productos/index', ['productos' => $productos, 'title' => 'Gestión de Productos']);
    }

    // Mostrar formulario para crear un nuevo producto
    public function create() {
        $this->view('productos/create', ['title' => 'Nuevo Producto']);
    }

    // Guardar un nuevo producto en la BD
    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $data = [
                'codigo' => $_POST['codigo'],
                'nombre' => $_POST['nombre'],
                'descripcion' => $_POST['descripcion'],
                'precio_venta' => $_POST['precio_venta'],
                'precio_compra' => $_POST['precio_compra'],
                'stock' => $_POST['stock']
            ];
            if ($this->productoModel->create($data)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=producto&action=index');
                exit;
            } else {
                die('Error al crear el producto.');
            }
        }
    }

    // Mostrar formulario para editar un producto
    public function edit() {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            $producto = $this->productoModel->getById($id);
            if ($producto) {
                $this->view('productos/edit', ['producto' => $producto, 'title' => 'Editar Producto']);
            } else {
                die('Producto no encontrado.');
            }
        }
    }

    // Actualizar un producto en la BD
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id'])) {
            $id = $_POST['id'];
            $data = [
                'codigo' => $_POST['codigo'],
                'nombre' => $_POST['nombre'],
                'descripcion' => $_POST['descripcion'],
                'precio_venta' => $_POST['precio_venta'],
                'precio_compra' => $_POST['precio_compra'],
                'stock' => $_POST['stock']
            ];
            if ($this->productoModel->update($id, $data)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=producto&action=index');
                exit;
            } else {
                die('Error al actualizar el producto.');
            }
        }
    }

    // Eliminar un producto
    public function delete() {
        if (isset($_GET['id'])) {
            $id = $_GET['id'];
            if ($this->productoModel->delete($id)) {
                // Headers para prevenir el cacheo
                header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
                header("Cache-Control: post-check=0, pre-check=0", false);
                header("Pragma: no-cache");
                header('Location: index.php?controller=producto&action=index');
                exit;
            } else {
                die('Error al eliminar el producto.');
            }
        }
    }
}
