<?php
// controllers/VentaController.php

require_once 'BaseController.php';

class VentaController extends BaseController {
    private $ventaModel;
    private $clienteModel;
    private $productoModel;

    public function __construct() {
        $this->ventaModel = new Venta();
        $this->clienteModel = new Cliente();
        $this->productoModel = new Producto();
    }

    // Muestra el formulario para una nueva venta
    public function create() {
        $clientes = $this->clienteModel->getAll();
        $productos = $this->productoModel->getAll(); // Idealmente, esto debería ser una búsqueda AJAX para grandes catálogos
        
        $this->view('ventas/create', [
            'clientes' => $clientes,
            'productos' => $productos,
            'title' => 'Nueva Nota de Venta'
        ]);
    }

    // Procesa y guarda la nueva venta
    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $idCliente = $_POST['id_cliente'];
            $totalVenta = $_POST['total_venta'];
            
            // Los productos vienen como un string JSON
            $productosJSON = $_POST['productos'];
            $productos = json_decode($productosJSON, true);

            if (empty($idCliente) || empty($productos) || !is_numeric($totalVenta)) {
                // Manejar error: datos incompletos
                // Podríamos redirigir con un mensaje de error
                header('Location: index.php?controller=venta&action=create&error=1');
                exit;
            }

            // Llamar al modelo para crear la venta
            $idVenta = $this->ventaModel->create($idCliente, $totalVenta, $productos);

            if ($idVenta) {
                // Redirigir a la página del recibo para imprimir
                header('Location: index.php?controller=venta&action=recibo&id=' . $idVenta);
            } else {
                // Manejar error en la creación de la venta
                header('Location: index.php?controller=venta&action=create&error=2');
            }
        }
    }
    
    // Muestra el recibo de una venta para imprimir
    public function recibo() {
        if (!isset($_GET['id'])) {
            die("Error: ID de venta no proporcionado.");
        }
        
        $idVenta = $_GET['id'];
        $venta = $this->ventaModel->getVentaById($idVenta);
        $detalles = $this->ventaModel->getDetallesByVentaId($idVenta);
        
        if (!$venta) {
            die("Error: Venta no encontrada.");
        }
        
        // Cargar la vista de impresión, que es diferente del layout principal
        $this->view('ventas/recibo', [
            'venta' => $venta,
            'detalles' => $detalles,
            'title' => 'Recibo de Venta #' . $idVenta
        ]);
    }
}
