<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h2 class="card-title">Gestión de Clientes</h2>
        <a href="index.php?controller=cliente&action=create" class="btn btn-primary">
            <i class="bi bi-plus-circle-fill"></i> Nuevo Cliente
        </a>
    </div>
    <div class="card-body">
        <!-- Formulario de búsqueda -->
        <form action="index.php" method="GET" class="mb-4">
            <input type="hidden" name="controller" value="cliente">
            <input type="hidden" name="action" value="index">
            <div class="input-group">
                <input type="text" name="search" class="form-control" placeholder="Buscar por Cédula/RUC o Nombre..." value="<?php echo htmlspecialchars($searchTerm ?? ''); ?>">
                <button class="btn btn-secondary" type="submit"><i class="bi bi-search"></i> Buscar</button>
                <?php if (!empty($searchTerm)): ?>
                    <a href="index.php?controller=cliente&action=index" class="btn btn-light">Limpiar</a>
                <?php endif; ?>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Cédula/RUC</th>
                        <th>Nombre</th>
                        <th>Dirección</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($clientes as $cliente): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($cliente['id']); ?></td>
                        <td><?php echo htmlspecialchars($cliente['cedula_ruc']); ?></td>
                        <td><?php echo htmlspecialchars($cliente['nombre']); ?></td>
                        <td><?php echo htmlspecialchars($cliente['direccion']); ?></td>
                        <td><?php echo htmlspecialchars($cliente['telefono']); ?></td>
                        <td><?php echo htmlspecialchars($cliente['email']); ?></td>
                        <td>
                            <a href="index.php?controller=cliente&action=edit&id=<?php echo $cliente['id']; ?>" class="btn btn-warning btn-sm">
                                <i class="bi bi-pencil-square"></i>
                            </a>
                            <a href="index.php?controller=cliente&action=delete&id=<?php echo $cliente['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro de que desea eliminar este cliente?');">
                                <i class="bi bi-trash-fill"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                     <?php if (empty($clientes)): ?>
                        <tr>
                            <td colspan="7" class="text-center">No se encontraron clientes.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
