<div class="card">
    <div class="card-header">
        <h2>Reporte de Productos y Stock</h2>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Código</th>
                        <th>Nombre</th>
                        <th>Descripción</th>
                        <th>Precio Venta</th>
                        <th>Stock Actual</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($productos as $producto): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($producto['id']); ?></td>
                        <td><?php echo htmlspecialchars($producto['codigo']); ?></td>
                        <td><?php echo htmlspecialchars($producto['nombre']); ?></td>
                        <td><?php echo htmlspecialchars($producto['descripcion']); ?></td>
                        <td>$<?php echo htmlspecialchars(number_format($producto['precio_venta'], 2)); ?></td>
                        <td class="<?php echo ($producto['stock'] < 10) ? 'table-danger fw-bold' : ''; ?>">
                            <?php echo htmlspecialchars($producto['stock']); ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="alert alert-info mt-3">
            <i class="bi bi-info-circle-fill"></i>
            El stock en rojo indica un nivel bajo (menos de 10 unidades).
        </div>
    </div>
</div>
